/************************************************************************
*	Resolvendo Subproblema Lagrangeano via CPLEX
*
*************************************************************************/
# include <ilcplex/ilocplex.h>

using namespace std;

double splx_lap(int n, double **c, double  **xl)
{
int k, i;
double lapcost;
// construindo ambiente de programacao matematica
IloEnv env;
IloModel mod(env);
IloNumVarArray x(env, n2, 0.0, 1.0, ILOINT);

// Introduzindo funcao objetivo
IloExpr expr(env);

for(k = 0; k < n; k++){
 for(i = 0; i < n; i++){
    expr+= c[k][i] * x[((k-1)*n + i)];
 }
}
mod.add(IloMinimize(env,expr));

// Introduzindo restricoes de Assignment

// somatorio em i
for(k=0;k<n;k++){
 IloExpr expr(env);
 for(i=0;i<n;i++) expr+= x[((k-1)*n + i)];
 mod.add(1<=expr<=1);
}

// somatorio em k
for(i=0;i<n;i++){
 IloExpr expr(env);
 for(k=0;k<n;k++) expr+= x[((k-1)*n + i)];
 mod.add(1<=expr<=1);
}

IloCplex cplex(mod);
cplex.setParam(IloCplex::MIPDisplay, 0);
cplex.solve();

	for(k=0;k<n;k++){
	 for(i=0;i<n;i++){
	 	xl[k][i] = (double)cplex.getValue(x[((k-1)*n+i)]);
	 	if(xl[k][i]<=0) xl[k][i] = 0;
	 }
	}

lapcost = cplex.getObjValue();
env.end();
return lapcost;
}

