/************************************************************************
*
*  lapmain.cpp
   version 1.0 - 4 September 1996
   author: Roy Jonker @ MagicLogic Optimization Inc.
   
   main program file to run and check Jonker-Volgenant LAP code
*
*************************************************************************/
#include "lap.cpp"
#include "lap.h"
using namespace std;

#if !defined TRUE
#define	 TRUE		1
#endif
#if !defined FALSE
#define  FALSE		0
#endif

/*************** DATA TYPES *******************/

typedef int boolean;

/*************** CONSTANTS  *******************/

  #define BIG 100000

/*************** TYPES      *******************/

  typedef int row;
  typedef int col;
  typedef double cost;


double splx_lap(int n, double **cost, int  **x)
{

  cost **assigncost, *u, *v, lapcost;
  row i, *colsol;
  col j, *rowsol;

  assigncost = new cost*[n];
  for (i = 0; i < n; i++)
    assigncost[i] = new cost[n];

  rowsol = new col[n];
  colsol = new row[n];
  u = new cost[n];
  v = new cost[n];


    for (i = 0; i < n; i++)
    {
      for (j = 0; j < n; j++)
        assigncost[i][j] = cost;
    }

/*    for (i = 0; i < n; i++)
    {
      printf("\n");
      for (j = 0; j < n; j++)
        printf("%5.3f ", assigncost[i][j]);
    }
*/
    lapcost = lap(n, assigncost, rowsol, colsol, u, v);
    for(i = 0; i < n; i++)x[i][rowsol[i]] = 1;


    //checklap(n, assigncost, rowsol, colsol, u, v);

  delete[] assigncost;
  delete[] rowsol;
  delete[] colsol;
  delete[] u;
  delete[] v;

return lapcost;
}

