/************************************************************************
*
*  lapmain.cpp
   version 1.0 - 4 September 1996
   author: Roy Jonker @ MagicLogic Optimization Inc.
   
   main program file to run and check Jonker-Volgenant LAP code
*
*************************************************************************/
#include "lap.h"

using namespace std;

double splx_lap(int n, double **c, int  **x)
{
  int k, l;
  cost **assigncost, *u, *v, lapcost;
  row i, *colsol;
  col j, *rowsol;

  assigncost = new cost*[n];
  for (i = 0; i < n; i++)
    assigncost[i] = new cost[n];

  rowsol = new col[n];
  colsol = new row[n];
  u = new cost[n];
  v = new cost[n];


    for (k = 0; k < n; k++)
    {
      for (l = 0; l < n; l++)
        assigncost[k][l] = c[k][l];
    }

/*    for (i = 0; i < n; i++)
    {
      printf("\n");
      for (j = 0; j < n; j++)
        printf("%5.3f ", assigncost[i][j]);
    }
*/
    lapcost = lap(n, assigncost, rowsol, colsol, u, v);
    for(k = 0; k < n; k++)
	{
	 for(l = 0; l < n; l++)
		x[k][l] = 0;
        }

    for(k = 0; k < n; k++)x[k][rowsol[k]] = 1;


    //checklap(n, assigncost, rowsol, colsol, u, v);

  delete[] assigncost;
  delete[] rowsol;
  delete[] colsol;
  delete[] u;
  delete[] v;

return lapcost;
}

