/************************************************************************
*
*  lapmain.cpp
   version 1.0 - 4 September 1996
   author: Roy Jonker @ MagicLogic Optimization Inc.
   
   main program file to run and check Jonker-Volgenant LAP code
*
*************************************************************************/
#include <iostream>
#include <iomanip>
#include <stdio.h>
#include <stdlib.h>
#include <fstream>
#include "lap.cpp"
#include "lap.h"
using namespace std;

#if !defined TRUE
#define	 TRUE		1
#endif
#if !defined FALSE
#define  FALSE		0
#endif

/*************** DATA TYPES *******************/

typedef int boolean;


int main(int argc, char *argv[])
{

  int n, **x;
  cost **assigncost, *u, *v, lapcost;
  row i, *colsol;
  col j, *rowsol;

  ifstream data(argv[1]); 

  data>>n;

  assigncost = new cost*[n];
  for (i = 0; i < n; i++)
    assigncost[i] = new cost[n];

  x = new int*[n];
  for (i = 0; i < n; i++)
    x[i] = new int[n];

  rowsol = new col[n];
  colsol = new row[n];
  u = new cost[n];
  v = new cost[n];


    for (i = 0; i < n; i++)
    {
      for (j = 0; j < n; j++)
        data>>assigncost[i][j];
    }

    for (i = 0; i < n; i++)
    {
      printf("\n");
      for (j = 0; j < n; j++)
        printf("%5.3f ", assigncost[i][j]);
    }

    lapcost = lap(n, assigncost, rowsol, colsol, u, v);

    printf("\n\ndim  %4d - lap cost %10.5f \n", n, lapcost);

    printf(" Assignment: \n");
    for(i = 0; i < n; i++)x[i][rowsol[i]] = 1;

    printf("\n");

    for(i = 0; i < n; i++)
    {
    	for (j = 0; j < n; j++) cout<<" "<<x[i][j];
	cout<<"\n";
    }

    //checklap(n, assigncost, rowsol, colsol, u, v);

  delete[] assigncost;
  delete[] rowsol;
  delete[] colsol;
  delete[] u;
  delete[] v;

return 0;
}

