set K;
set I;

param b{k in K, l in K};
param c{i in I, j in I};

var x{k in K, i in I}binary;
var f{k in K, l in K, i in I, j in I: i!=j and k<l and (b[k,l]!=0 or b[l,k]!=0)}>=0;

minimize cost: sum{k in K, l in K, i in I, j in I: i!=j and k<l and (b[k,l]!=0 or b[l,k]!=0)} (c[i,j]*b[k,l]+c[j,i]*b[l,k])*f[k,l,i,j];

s.t. assk{k in K}: sum{i in I}x[k,i] = 1;
s.t. assi{i in I}: sum{k in K}x[k,i] = 1;
s.t. offers{k in K, l in K, i in I: k<l and (b[k,l]!=0 or b[l,k]!=0)}: sum{j in I: j!=i} f[k,l,i,j] = x[k,i];
s.t. demand{k in K, l in K, j in I: k<l and (b[k,l]!=0 or b[l,k]!=0)}: sum{i in I: j!=i} f[k,l,i,j] = x[l,j];
s.t. strong{k in K, i in I, j in I: i!=j}: sum{l in K: k<l and (b[k,l]!=0 or b[l,k]!=0)} f[k,l,i,j] + 
					   sum{l in K: k>l and (b[k,l]!=0 or b[l,k]!=0)} f[l,k,j,i] <= x[k,i];
end;