#
#   Network Design: Fomulacao Produto unico
#
#

set I;

param a{i in I, j in I};
param d{i in I, j in I};
param beta;
param gama;
param b{i in I};
param M:= sum{i in I: i>1}b[i];

var x{i in I, j in I: a[i,j] = 1}binary;
var f{i in I, j in I: a[i,j] = 1}>=0;

minimize custo: sum{i in I, j in I: a[i,j]=1}beta*d[i,j]*x[i,j] + sum{i in I, j in I: a[i,j]=1}gama*d[i,j]*f[i,j];

s.t. flowbal{i in I}: sum{j in I: a[j,i]=1}f[j,i] - sum{j in I: a[i,j]=1}f[i,j] = b[i];
s.t. linkact{i in I, j in I: a[j,i]=1}: f[i,j] <= M*x[i,j];

end;