#
#   Network Design: Fomulacao Multi-Produto 
#
#

set I;

param a{i in I, j in I};
param d{i in I, j in I};
param beta;
param gama;
param b{i in I};

var x{i in I, j in I: a[i,j] = 1}binary;
var f{i in I, j in I, k in I: a[i,j] = 1 and b[k]>0}>=0;

minimize custo: sum{i in I, j in I: a[i,j]=1}beta*d[i,j]*x[i,j] + 
                sum{i in I, j in I, k in I: a[i,j]=1 and b[k]>0}gama*d[i,j]*f[i,j,k];

s.t. ofertas{k in I: b[k]>0}:  - sum{j in I: a[1,j]=1}f[1,j,k] = -b[k];  
s.t. demanda{k in I: b[k]>0}:    sum{i in I: a[i,k]=1}f[i,k,k] =  b[k];
s.t. transhp{k in I, i in I: i>1 and k>1 and i!=k and b[k]!=0 and b[i]=0}: sum{j in I: a[j,i]=1}f[j,i,k] = sum{l in I: a[i,l]=1}f[i,l,k];

s.t. linkact{i in I, j in I, k in I: a[j,i]=1 and b[k]>0}: f[i,j,k] <= b[k]*x[i,j];

end;