################################################
#	 USAHLP para Cellular Manufacturing    #
#	 Autor: G. Miranda                     #
#	 Maio de 2005                          #
################################################

set I; # locais

param c{i in I, k in I};
param w{i in I, j in I};
param a{k in I};
param d;

var x{i in I, j in I, k in I, m in I}>=0;
var y{k in I}binary;

minimize custo: sum{i in I, j in I, k in I, m in I: i!=j}(c[i,k] + d*c[k,m] + c[m,j])* w[i,j]*x[i,j,k,m] +
                sum{k in I}a[k]*y[k];

s.t. assgn{i in I, j in I:i!=j}: sum{k in I, m in I}x[i,j,k,m] = 1;
s.t. coupl1{i in I, j in I, k in I:i!=j}: sum{m in I: m!=k}x[i,j,m,k] + sum{m in I}x[i,j,k,m]<= y[k];

end;
